#! /usr/local/bin/perl
#-------------------------------------------------------------------------------
#    
#    Name:          Simple Flash Echo 
#    Version:       1.2.1
#    Author:        Derek Clayton	derek@moock.org
#
#    Description:   Zwraca pary nazwa/wartosc otrzymane z GET lub POST
#-------------------------------------------------------------------------------
# MAIN
#-------------------------------------------------------------------------------
#

use CGI;                    # Uzyj CGI.pm do usprawnienia parsowania
$query = new CGI;           # Obiekt query

$echoString = "output=";    # Inicjalizuj tekst wejsciowy
&getInput;                  # Pobierz dane wejsciowe z Flasha
&writeResponse;             # Napisz odpowiedz dla Flasha

exit;                       # Zakocz skrypt

#-------------------------------------------------------------------------------

sub getInput {
    # dla kazdego klawisza ustal przypisana mu wartosc i dodaj ja do ciagu znakow
    # wysylanego w odpowiedzi
    foreach $key ($query->param) {
        $value = $query->param($key);
        $echoString .= "$key:$value\n";  
    }

    # Usun pozostalosci po poczatku linii (\n) przed napisaniem odpowiedzi
    chomp($echoString);
}

sub writeResponse {
    # Ustal typ danych dla Flasha
    print $query->header({"Content-Type"=>"application/x-www-form-urlencoded"});


    
    # Napisz odpowiedz
    print $echoString;
}
